<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Material extends Model 
{

    protected $table = 'materials';
    public $timestamps = true;
    protected $fillable = array('category_id', 'title', 'author_id', 'image', 'background_color', 'sound_track', 'minutes', 'description', 'listen_count', 'is_paid');

    public function authors()
    {
        return $this->belongsTo('App\Models\Author');
    }

    public function category()
    {
        return $this->belongsTo('App\Models\Category');
    }

    public function notification()
    {
        return $this->hasOne('App\Models\Notification');
    }

}